﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

public class TileManager : MonoBehaviour {

	public GameObject[] tilePrefabs;
	public Transform target;
	//initial position
	private Vector3 pos = new Vector3 (0.0f,0.0f,0.0f);
	private List<GameObject> tempGameObjects;

	void Start () {
		tempGameObjects = new List<GameObject> ();
		tempGameObjects.Add (Instantiate (tilePrefabs [0], pos, Quaternion.identity) as GameObject);
	}
		
	void Update () {
		SpawnTile ();
		DeleteTile ();
	}
	//Tile spawning function	
	public void SpawnTile() {
		if (tempGameObjects[tempGameObjects.Count - 1].transform.position.x - target.position.x < 200.0f) {
			int randomindex = Random.Range (0, 5);
			pos.x += 40.0f;
			tempGameObjects.Add (Instantiate (tilePrefabs [randomindex], pos, Quaternion.identity) as GameObject);
		}
	}
	//tile deleting function
	public void DeleteTile() {
		for (int i = 0; i < tempGameObjects.Count - 1; ++i) {
			if ((tempGameObjects [i] != null) && (target.position.x - tempGameObjects [i].transform.position.x > 80.0f)) {
				DestroyObject (tempGameObjects [i]);
				tempGameObjects.RemoveAt (i);
			}
		}
	}

}

